namespace WinFormsApp1;

public partial class Form1 : Form
{
    public Form1()
    {
        InitializeComponent();
    }

    private string _operator = "";
    private bool _isOperatorActive = false;
    private double _memoNumber = 0;
    
    private void Numbers(object sender, EventArgs e)
    {
        Button button = (Button)sender;
        if (_isOperatorActive)
        {
            _memoNumber = double.Parse(currentValue.Text);
            currentValue.Text = "0";
            _isOperatorActive = false;
        }
        
        if (button.Text == ",")
        {
            if (!currentValue.Text.Contains(','))
            {
                currentValue.Text += button.Text;
            }
        }
        else
        {
            if (currentValue.Text == "0")
            {
                currentValue.Text = button.Text;        
            }
            else
            {
                currentValue.Text += button.Text;
            }
        }
        
    }

    private void Operators(object sender, EventArgs e)
    {
        Button button = (Button)sender;
        _isOperatorActive = true;
        _operator = button.Text;
    }

    private void Backspace(object sender, EventArgs e)
    {
        string text = currentValue.Text.Substring(0, currentValue.Text.Length -1);
        if (text.Length == 0)
        {
            currentValue.Text = "0";
        }
        else
        {
            currentValue.Text = text;
        }
    }

    private void Clear(object sender, EventArgs e)
    {
        currentValue.Text = "0";
    }

    private void ClearAll(object sender, EventArgs e)
    {
        currentValue.Text = "0";
        _isOperatorActive = false;
        _memoNumber = 0;
        _operator = "";
    }

    private void Equal(object sender, EventArgs e)
    {
        double result = 0;
        switch (_operator)
        {
            case "+":
                result = _memoNumber + double.Parse(currentValue.Text);
                break;
            case  "-":
                result = _memoNumber - double.Parse(currentValue.Text);
                break;
            case "x":
                result = _memoNumber * double.Parse(currentValue.Text);
                break;
            case "/":
                result = _memoNumber / double.Parse(currentValue.Text);
                break;
        }

        WriteProcess();
        _memoNumber = result;
        currentValue.Text = result.ToString();
    }

    private void WriteProcess()
    {
        labelValue.Text = _memoNumber + " " + _operator + " " + currentValue.Text + " =";
    }
}